<?php
// create_test_user.php
require 'db_connection.php';

$name = 'System Admin';
$email = 'joram@ncdc.go.ug';
$password = 'admin123'; // This is what you will type into the login screen
$role_id = 1; // Assuming 1 is the Admin role

// 1. Hash the password securely
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

try {
    // 2. Insert into the database
    $stmt = $pdo->prepare("INSERT INTO users (name, email, password_hash, role_id, status) VALUES (?, ?, ?, ?, 'active')");
    $stmt->execute([$name, $email, $hashed_password, $role_id]);
    
    echo "<h2 style='color: #0A5C36; font-family: sans-serif;'>Success! Test User Created.</h2>";
    echo "<p style='font-family: sans-serif;'><strong>Email:</strong> admin@ncdc.go.ug</p>";
    echo "<p style='font-family: sans-serif;'><strong>Password:</strong> admin123</p>";
    echo "<p style='font-family: sans-serif;'>You can now delete this file and go test the <a href='login.php'>Login Page</a>.</p>";
} catch (PDOException $e) {
    echo "Error: It looks like this user might already exist, or there is a database issue. " . $e->getMessage();
}
?>